<?php
/**
 * The template to display the widgets area in the header
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

// Header sidebar
$eventicity_header_name    = eventicity_get_theme_option( 'header_widgets' );
$eventicity_header_present = ! eventicity_is_off( $eventicity_header_name ) && is_active_sidebar( $eventicity_header_name );
if ( $eventicity_header_present ) {
	eventicity_storage_set( 'current_sidebar', 'header' );
	$eventicity_header_wide = eventicity_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $eventicity_header_name ) ) {
		dynamic_sidebar( $eventicity_header_name );
	}
	$eventicity_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $eventicity_widgets_output ) ) {
		$eventicity_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $eventicity_widgets_output );
		$eventicity_need_columns   = strpos( $eventicity_widgets_output, 'columns_wrap' ) === false;
		if ( $eventicity_need_columns ) {
			$eventicity_columns = max( 0, (int) eventicity_get_theme_option( 'header_columns' ) );
			if ( 0 == $eventicity_columns ) {
				$eventicity_columns = min( 6, max( 1, eventicity_tags_count( $eventicity_widgets_output, 'aside' ) ) );
			}
			if ( $eventicity_columns > 1 ) {
				$eventicity_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $eventicity_columns ) . ' widget', $eventicity_widgets_output );
			} else {
				$eventicity_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $eventicity_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'eventicity_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $eventicity_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $eventicity_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'eventicity_action_before_sidebar', 'header' );
				eventicity_show_layout( $eventicity_widgets_output );
				do_action( 'eventicity_action_after_sidebar', 'header' );
				if ( $eventicity_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $eventicity_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'eventicity_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
