<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

$eventicity_template_args = get_query_var( 'eventicity_template_args' );
if ( is_array( $eventicity_template_args ) ) {
	$eventicity_columns    = empty( $eventicity_template_args['columns'] ) ? 2 : max( 1, $eventicity_template_args['columns'] );
	$eventicity_blog_style = array( $eventicity_template_args['type'], $eventicity_columns );
    $eventicity_columns_class = eventicity_get_column_class( 1, $eventicity_columns, ! empty( $eventicity_template_args['columns_tablet']) ? $eventicity_template_args['columns_tablet'] : '', ! empty($eventicity_template_args['columns_mobile']) ? $eventicity_template_args['columns_mobile'] : '' );
} else {
	$eventicity_template_args = array();
	$eventicity_blog_style = explode( '_', eventicity_get_theme_option( 'blog_style' ) );
	$eventicity_columns    = empty( $eventicity_blog_style[1] ) ? 2 : max( 1, $eventicity_blog_style[1] );
    $eventicity_columns_class = eventicity_get_column_class( 1, $eventicity_columns );
}

$eventicity_post_format = get_post_format();
$eventicity_post_format = empty( $eventicity_post_format ) ? 'standard' : str_replace( 'post-format-', '', $eventicity_post_format );

?><div class="
<?php
if ( ! empty( $eventicity_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( eventicity_is_blog_style_use_masonry( $eventicity_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $eventicity_columns ) : esc_attr( $eventicity_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $eventicity_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $eventicity_columns )
		. ( 'portfolio' != $eventicity_blog_style[0] ? ' ' . esc_attr( $eventicity_blog_style[0] )  . '_' . esc_attr( $eventicity_columns ) : '' )
	);
	eventicity_add_blog_animation( $eventicity_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$eventicity_hover   = ! empty( $eventicity_template_args['hover'] ) && ! eventicity_is_inherit( $eventicity_template_args['hover'] )
								? $eventicity_template_args['hover']
								: eventicity_get_theme_option( 'image_hover' );

	if ( 'dots' == $eventicity_hover ) {
		$eventicity_post_link = empty( $eventicity_template_args['no_links'] )
								? ( ! empty( $eventicity_template_args['link'] )
									? $eventicity_template_args['link']
									: get_permalink()
									)
								: '';
		$eventicity_target    = ! empty( $eventicity_post_link ) && eventicity_is_external_url( $eventicity_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$eventicity_components = ! empty( $eventicity_template_args['meta_parts'] )
							? ( is_array( $eventicity_template_args['meta_parts'] )
								? $eventicity_template_args['meta_parts']
								: explode( ',', $eventicity_template_args['meta_parts'] )
								)
							: eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'meta_parts' ) );

	// Featured image
	eventicity_show_post_featured( apply_filters( 'eventicity_filter_args_featured',
        array(
			'hover'         => $eventicity_hover,
			'no_links'      => ! empty( $eventicity_template_args['no_links'] ),
			'thumb_size'    => ! empty( $eventicity_template_args['thumb_size'] )
								? $eventicity_template_args['thumb_size']
								: eventicity_get_thumb_size(
									eventicity_is_blog_style_use_masonry( $eventicity_blog_style[0] )
										? (	strpos( eventicity_get_theme_option( 'body_style' ), 'full' ) !== false || $eventicity_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( eventicity_get_theme_option( 'body_style' ), 'full' ) !== false || $eventicity_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => eventicity_is_blog_style_use_masonry( $eventicity_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $eventicity_components,
			'class'         => 'dots' == $eventicity_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $eventicity_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $eventicity_post_link )
												? '<a href="' . esc_url( $eventicity_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $eventicity_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $eventicity_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $eventicity_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!