<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

$eventicity_template_args = get_query_var( 'eventicity_template_args' );
$eventicity_columns = 1;
if ( is_array( $eventicity_template_args ) ) {
	$eventicity_columns    = empty( $eventicity_template_args['columns'] ) ? 1 : max( 1, $eventicity_template_args['columns'] );
	$eventicity_blog_style = array( $eventicity_template_args['type'], $eventicity_columns );
	if ( ! empty( $eventicity_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $eventicity_columns > 1 ) {
	    $eventicity_columns_class = eventicity_get_column_class( 1, $eventicity_columns, ! empty( $eventicity_template_args['columns_tablet']) ? $eventicity_template_args['columns_tablet'] : '', ! empty($eventicity_template_args['columns_mobile']) ? $eventicity_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $eventicity_columns_class ); ?>">
		<?php
	}
} else {
	$eventicity_template_args = array();
}
$eventicity_expanded    = ! eventicity_sidebar_present() && eventicity_get_theme_option( 'expand_content' ) == 'expand';
$eventicity_post_format = get_post_format();
$eventicity_post_format = empty( $eventicity_post_format ) ? 'standard' : str_replace( 'post-format-', '', $eventicity_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $eventicity_post_format ) );
	eventicity_add_blog_animation( $eventicity_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$eventicity_hover      = ! empty( $eventicity_template_args['hover'] ) && ! eventicity_is_inherit( $eventicity_template_args['hover'] )
							? $eventicity_template_args['hover']
							: eventicity_get_theme_option( 'image_hover' );
	$eventicity_components = ! empty( $eventicity_template_args['meta_parts'] )
							? ( is_array( $eventicity_template_args['meta_parts'] )
								? $eventicity_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $eventicity_template_args['meta_parts'] ) )
								)
							: eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'meta_parts' ) );
	eventicity_show_post_featured( apply_filters( 'eventicity_filter_args_featured',
		array(
			'no_links'   => ! empty( $eventicity_template_args['no_links'] ),
			'hover'      => $eventicity_hover,
			'meta_parts' => $eventicity_components,
			'thumb_size' => ! empty( $eventicity_template_args['thumb_size'] )
							? $eventicity_template_args['thumb_size']
							: eventicity_get_thumb_size( strpos( eventicity_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $eventicity_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$eventicity_template_args
	) );

	// Title and post meta
	$eventicity_show_title = get_the_title() != '';
	$eventicity_show_meta  = count( $eventicity_components ) > 0 && ! in_array( $eventicity_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $eventicity_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'eventicity_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'eventicity_action_before_post_title' );
				if ( empty( $eventicity_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'eventicity_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'eventicity_filter_show_blog_excerpt', empty( $eventicity_template_args['hide_excerpt'] ) && eventicity_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'eventicity_filter_show_blog_meta', $eventicity_show_meta, $eventicity_components, 'excerpt' ) ) {
				if ( count( $eventicity_components ) > 0 ) {
					do_action( 'eventicity_action_before_post_meta' );
					eventicity_show_post_meta(
						apply_filters(
							'eventicity_filter_post_meta_args', array(
								'components' => join( ',', $eventicity_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'eventicity_action_after_post_meta' );
				}
			}

			if ( eventicity_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'eventicity_action_before_full_post_content' );
					the_content( '' );
					do_action( 'eventicity_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'eventicity' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'eventicity' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				eventicity_show_post_content( $eventicity_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'eventicity_filter_show_blog_readmore',  ! isset( $eventicity_template_args['more_button'] ) || ! empty( $eventicity_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $eventicity_template_args['no_links'] ) ) {
					do_action( 'eventicity_action_before_post_readmore' );
					if ( eventicity_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						eventicity_show_post_more_link( $eventicity_template_args, '<p>', '</p>' );
					} else {
						eventicity_show_post_comments_link( $eventicity_template_args, '<p>', '</p>' );
					}
					do_action( 'eventicity_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $eventicity_template_args ) ) {
	if ( ! empty( $eventicity_template_args['slider'] ) || $eventicity_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
