<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0.50
 */

$eventicity_template_args = get_query_var( 'eventicity_template_args' );
if ( is_array( $eventicity_template_args ) ) {
	$eventicity_columns    = empty( $eventicity_template_args['columns'] ) ? 2 : max( 1, $eventicity_template_args['columns'] );
	$eventicity_blog_style = array( $eventicity_template_args['type'], $eventicity_columns );
} else {
	$eventicity_template_args = array();
	$eventicity_blog_style = explode( '_', eventicity_get_theme_option( 'blog_style' ) );
	$eventicity_columns    = empty( $eventicity_blog_style[1] ) ? 2 : max( 1, $eventicity_blog_style[1] );
}
$eventicity_blog_id       = eventicity_get_custom_blog_id( join( '_', $eventicity_blog_style ) );
$eventicity_blog_style[0] = str_replace( 'blog-custom-', '', $eventicity_blog_style[0] );
$eventicity_expanded      = ! eventicity_sidebar_present() && eventicity_get_theme_option( 'expand_content' ) == 'expand';
$eventicity_components    = ! empty( $eventicity_template_args['meta_parts'] )
							? ( is_array( $eventicity_template_args['meta_parts'] )
								? join( ',', $eventicity_template_args['meta_parts'] )
								: $eventicity_template_args['meta_parts']
								)
							: eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'meta_parts' ) );
$eventicity_post_format   = get_post_format();
$eventicity_post_format   = empty( $eventicity_post_format ) ? 'standard' : str_replace( 'post-format-', '', $eventicity_post_format );

$eventicity_blog_meta     = eventicity_get_custom_layout_meta( $eventicity_blog_id );
$eventicity_custom_style  = ! empty( $eventicity_blog_meta['scripts_required'] ) ? $eventicity_blog_meta['scripts_required'] : 'none';

if ( ! empty( $eventicity_template_args['slider'] ) || $eventicity_columns > 1 || ! eventicity_is_off( $eventicity_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $eventicity_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( eventicity_is_off( $eventicity_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $eventicity_custom_style ) ) . "-1_{$eventicity_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $eventicity_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $eventicity_columns )
					. ' post_layout_' . esc_attr( $eventicity_blog_style[0] )
					. ' post_layout_' . esc_attr( $eventicity_blog_style[0] ) . '_' . esc_attr( $eventicity_columns )
					. ( ! eventicity_is_off( $eventicity_custom_style )
						? ' post_layout_' . esc_attr( $eventicity_custom_style )
							. ' post_layout_' . esc_attr( $eventicity_custom_style ) . '_' . esc_attr( $eventicity_columns )
						: ''
						)
		);
	eventicity_add_blog_animation( $eventicity_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'eventicity_action_show_layout', $eventicity_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $eventicity_template_args['slider'] ) || $eventicity_columns > 1 || ! eventicity_is_off( $eventicity_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
