<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

$eventicity_template_args = get_query_var( 'eventicity_template_args' );

if ( is_array( $eventicity_template_args ) ) {
	$eventicity_columns    = empty( $eventicity_template_args['columns'] ) ? 2 : max( 1, $eventicity_template_args['columns'] );
	$eventicity_blog_style = array( $eventicity_template_args['type'], $eventicity_columns );
    $eventicity_columns_class = eventicity_get_column_class( 1, $eventicity_columns, ! empty( $eventicity_template_args['columns_tablet']) ? $eventicity_template_args['columns_tablet'] : '', ! empty($eventicity_template_args['columns_mobile']) ? $eventicity_template_args['columns_mobile'] : '' );
} else {
	$eventicity_template_args = array();
	$eventicity_blog_style = explode( '_', eventicity_get_theme_option( 'blog_style' ) );
	$eventicity_columns    = empty( $eventicity_blog_style[1] ) ? 2 : max( 1, $eventicity_blog_style[1] );
    $eventicity_columns_class = eventicity_get_column_class( 1, $eventicity_columns );
}
$eventicity_expanded   = ! eventicity_sidebar_present() && eventicity_get_theme_option( 'expand_content' ) == 'expand';

$eventicity_post_format = get_post_format();
$eventicity_post_format = empty( $eventicity_post_format ) ? 'standard' : str_replace( 'post-format-', '', $eventicity_post_format );

?><div class="<?php
	if ( ! empty( $eventicity_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( eventicity_is_blog_style_use_masonry( $eventicity_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $eventicity_columns ) : esc_attr( $eventicity_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $eventicity_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $eventicity_columns )
				. ' post_layout_' . esc_attr( $eventicity_blog_style[0] )
				. ' post_layout_' . esc_attr( $eventicity_blog_style[0] ) . '_' . esc_attr( $eventicity_columns )
	);
	eventicity_add_blog_animation( $eventicity_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$eventicity_hover      = ! empty( $eventicity_template_args['hover'] ) && ! eventicity_is_inherit( $eventicity_template_args['hover'] )
							? $eventicity_template_args['hover']
							: eventicity_get_theme_option( 'image_hover' );

	$eventicity_components = ! empty( $eventicity_template_args['meta_parts'] )
							? ( is_array( $eventicity_template_args['meta_parts'] )
								? $eventicity_template_args['meta_parts']
								: explode( ',', $eventicity_template_args['meta_parts'] )
								)
							: eventicity_array_get_keys_by_value( eventicity_get_theme_option( 'meta_parts' ) );

	eventicity_show_post_featured( apply_filters( 'eventicity_filter_args_featured',
		array(
			'thumb_size' => ! empty( $eventicity_template_args['thumb_size'] )
				? $eventicity_template_args['thumb_size']
				: eventicity_get_thumb_size(
					'classic' == $eventicity_blog_style[0]
						? ( strpos( eventicity_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $eventicity_columns > 2 ? 'big' : 'huge' )
								: ( $eventicity_columns > 2
									? ( $eventicity_expanded ? 'square' : 'square' )
									: ($eventicity_columns > 1 ? 'square' : ( $eventicity_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( eventicity_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $eventicity_columns > 2 ? 'masonry-big' : 'full' )
								: ($eventicity_columns === 1 ? ( $eventicity_expanded ? 'huge' : 'big' ) : ( $eventicity_columns <= 2 && $eventicity_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $eventicity_hover,
			'meta_parts' => $eventicity_components,
			'no_links'   => ! empty( $eventicity_template_args['no_links'] ),
        ),
        'content-classic',
        $eventicity_template_args
    ) );

	// Title and post meta
	$eventicity_show_title = get_the_title() != '';
	$eventicity_show_meta  = count( $eventicity_components ) > 0 && ! in_array( $eventicity_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $eventicity_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'eventicity_filter_show_blog_meta', $eventicity_show_meta, $eventicity_components, 'classic' ) ) {
				if ( count( $eventicity_components ) > 0 ) {
					do_action( 'eventicity_action_before_post_meta' );
					eventicity_show_post_meta(
						apply_filters(
							'eventicity_filter_post_meta_args', array(
							'components' => join( ',', $eventicity_components ),
							'seo'        => false,
							'echo'       => true,
						), $eventicity_blog_style[0], $eventicity_columns
						)
					);
					do_action( 'eventicity_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'eventicity_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'eventicity_action_before_post_title' );
				if ( empty( $eventicity_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'eventicity_action_after_post_title' );
			}

			if( !in_array( $eventicity_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'eventicity_filter_show_blog_readmore', ! $eventicity_show_title || ! empty( $eventicity_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $eventicity_template_args['no_links'] ) ) {
						do_action( 'eventicity_action_before_post_readmore' );
						eventicity_show_post_more_link( $eventicity_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'eventicity_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $eventicity_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('eventicity_filter_show_blog_excerpt', empty($eventicity_template_args['hide_excerpt']) && eventicity_get_theme_option('excerpt_length') > 0, 'classic')) {
			eventicity_show_post_content($eventicity_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $eventicity_template_args['more_button'] )) {
			if ( empty( $eventicity_template_args['no_links'] ) ) {
				do_action( 'eventicity_action_before_post_readmore' );
				eventicity_show_post_more_link( $eventicity_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'eventicity_action_after_post_readmore' );
			}
		}
		$eventicity_content = ob_get_contents();
		ob_end_clean();
		eventicity_show_layout($eventicity_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
