<?php
/**
 * Skin Setup
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'eventicity_theme_defaults' ) ) {
	function eventicity_theme_defaults( $name='', $value='' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'eventicity_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'eventicity_filter_load_woocommerce_extensions', 'eventicity_skin_woocommerce_allow_extensions' );
	function eventicity_skin_woocommerce_allow_extensions( $allow ) {
		return false;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'eventicity_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'eventicity_skin_setup', 1 );
	function eventicity_skin_setup() {

		$GLOBALS['EVENTICITY_STORAGE'] = array_merge( $GLOBALS['EVENTICITY_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-themerex',

			'theme_doc_url'       => '//doc.themerex.net/eventicity/',

			'theme_demofiles_url' => '//demofiles.themerex.net/eventicity/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/themerex/portfolio',        						// ThemeREX

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',   					// ThemeREX

			'theme_privacy_url'   => '//themerex.com/privacy-policy/',                   						// ThemeREX

			'portfolio_url'       => '//themeforest.net/user/themerex/portfolio',        						// ThemeREX

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'eventicity_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'eventicity_skin_setup_settings', 1 );
	function eventicity_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		eventicity_storage_set_array( 'settings', 'thumbs_in_navigation', false );
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'eventicity_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'eventicity_skin_setup_fonts', 1 );
	function eventicity_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		eventicity_storage_set(
			'load_fonts', array(
                // Google fonts
				array(
					'name'   => 'Marcellus',
					'family' => 'serif',
					'link'   => '',
					'styles' => 'ital,wght@0,400;1,400',     // Parameter 'style' used only for the Google fonts
				),
                array(
					'name'   => 'DM Sans',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,400;0,500;0,700;1,400;1,500;1,700',     // Parameter 'style' used only for the Google fonts
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		eventicity_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => eventicity_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Font settings for the %s of the site. To ensure that the elements scale properly on mobile devices, please use only the following units: "rem", "em" or "ex"', 'eventicity' );

		eventicity_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'eventicity' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.7em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.6em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'eventicity' ) ),
					'font-family'     => '',			// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => '',			// Example: '400',
					'font-style'      => '',			// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => '',			// Example: 'none',
					'text-transform'  => '',			// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '3.353em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-1.8px',
					'margin-top'      => '1.08em',
					'margin-bottom'   => '0.4em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'eventicity' ) ),
                    'font-family'     => 'Marcellus,serif',
					'font-size'       => '2.765em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.1px',
					'margin-top'      => '0.74em',
					'margin-bottom'   => '0.5em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '2.059em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.94em',
					'margin-bottom'   => '0.62em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.647em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.15em',
					'margin-bottom'   => '0.6em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.412em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.417em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.3em',
					'margin-bottom'   => '0.65em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.118em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.474em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.75em',
					'margin-bottom'   => '1.08em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '1.6em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.2em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '16px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '20px',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'eventicity' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'eventicity' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
					'font-size'       => '17px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'eventicity' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'eventicity' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'eventicity' ) ),
					'font-family'     => 'Marcellus,serif',
				),
			)
		);

		// Font presets
		eventicity_storage_set(
		'font_presets', array(
			'karla' => array(
			'title'  => esc_html__( 'Karla', 'eventicity' ),
			'load_fonts' => array(
				// Google font
				array(
					'name'   => 'Dancing Script',
					'family' => 'fantasy',
					'link'   => '',
					'styles' => '300,400,700',
				),
				// Google font
				array(
					'name'   => 'Sansita Swashed',
					'family' => 'fantasy',
					'link'   => '',
					'styles' => '300,400,700',
				),
			),
			'theme_fonts' => array(
					'p'       => array(
						'font-family'     => '"Dancing Script",fantasy',
						'font-size'       => '1.25rem',
					),
					'post'    => array(
						'font-family'     => '',
					),
					'h1'      => array(
						'font-family'     => '"Sansita Swashed",fantasy',
						'font-size'       => '4em',
					),
					'h2'      => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'h3'      => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'h4'      => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'h5'      => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'h6'      => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'logo'    => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'button'  => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'input'   => array(
						'font-family'     => 'inherit',
					),
					'info'    => array(
						'font-family'     => 'inherit',
					),
					'menu'    => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
					'submenu' => array(
						'font-family'     => '"Sansita Swashed",fantasy',
					),
				),
			),
			'roboto' => array(
			'title'  => esc_html__( 'Roboto', 'eventicity' ),
			'load_fonts' => array(
					// Google font
					array(
						'name'   => 'Noto Sans JP',
						'family' => 'serif',
						'link'   => '',
						'styles' => '300,300italic,400,400italic,700,700italic',
					),
					// Google font
					array(
						'name'   => 'Merriweather',
						'family' => 'sans-serif',
						'link'   => '',
						'styles' => '300,300italic,400,400italic,700,700italic',
					),
				),
				'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Noto Sans JP",serif',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h2'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h3'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h4'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h5'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h6'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'logo'    => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'button'  => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'submenu' => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
					),
				),
				'garamond' => array(
				'title'  => esc_html__( 'Garamond', 'eventicity' ),
					'load_fonts' => array(
						// Adobe font
						array(
							'name'   => 'Europe',
							'family' => 'sans-serif',
							'link'   => 'https://use.typekit.net/qmj1tmx.css',
							'styles' => '',
						),
						// Adobe font
						array(
							'name'   => 'Sofia Pro',
							'family' => 'sans-serif',
							'link'   => 'https://use.typekit.net/qmj1tmx.css',
							'styles' => '',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Sofia Pro",sans-serif',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h2'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h3'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h4'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h5'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h6'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'logo'    => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'button'  => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'submenu' => array(
							'font-family'     => 'Europe,sans-serif',
						),
					),
				),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'eventicity_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'eventicity_skin_setup_schemes', 1 );
	function eventicity_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		eventicity_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'eventicity' ),
					'description' => esc_html__( 'Colors of the main content area', 'eventicity' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'eventicity' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'eventicity' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'eventicity' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'eventicity' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'eventicity' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'eventicity' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'eventicity' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'eventicity' ),
				),
			)
		);

		eventicity_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'eventicity' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'eventicity' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'eventicity' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'eventicity' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'eventicity' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'eventicity' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'eventicity' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'eventicity' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'eventicity' ),
					'description' => esc_html__( 'Color of the text inside this block', 'eventicity' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'eventicity' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'eventicity' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'eventicity' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'eventicity' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'eventicity' ),
					'description' => esc_html__( 'Color of the links inside this block', 'eventicity' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'eventicity' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'eventicity' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'eventicity' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'eventicity' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'eventicity' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'eventicity' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'eventicity' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'eventicity' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'eventicity' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'eventicity' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FCF7F4',
					'bd_color'         => '#E0DAD3',

					// Text and links colors
					'text'             => '#6B6B6B',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#F6B255',
					'text_hover'       => '#DC9B42',
					'text_link2'       => '#0868D7',
					'text_hover2'      => '#0051AF',
					'text_link3'       => '#1FA713',
					'text_hover3'      => '#118807',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#F1E9E4',
					'alter_bd_color'   => '#E0DAD3',
					'alter_bd_hover'   => '#C1BBB5',
					'alter_text'       => '#6B6B6B',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#F6B255',
					'alter_hover'      => '#DC9B42',
					'alter_link2'      => '#0868D7',
					'alter_hover2'     => '#0051AF',
					'alter_link3'      => '#1FA713',
					'alter_hover3'     => '#118807',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#232F3B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#35414B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D5D2D2',
					'extra_light'      => '#A09696',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#F6B255',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E0DAD3',
					'input_bd_hover'   => '#C1BBB5',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0E202D',
					'bd_color'         => '#35414B',

					// Text and links colors
					'text'             => '#D2D3D5',
					'text_light'       => '#9E9E9F',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#F6B255',
					'text_hover'       => '#DC9B42',
					'text_link2'       => '#0868D7',
					'text_hover2'      => '#0051AF',
					'text_link3'       => '#1FA713',
					'text_hover3'      => '#118807',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#112634',
					'alter_bg_hover'   => '#293B45',
					'alter_bd_color'   => '#35414B',
					'alter_bd_hover'   => '#455562',
					'alter_text'       => '#D2D3D5',
					'alter_light'      => '#9E9E9F',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#F6B255',
					'alter_hover'      => '#DC9B42',
					'alter_link2'      => '#0868D7',
					'alter_hover2'     => '#0051AF',
					'alter_link3'      => '#1FA713',
					'alter_hover3'     => '#118807',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#232F3B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#35414B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D5D2D2',
					'extra_light'      => '#A09696',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#F6B255',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#35414B',
					'input_bd_hover'   => '#455562',
					'input_text'       => '#D2D3D5',
					'input_light'      => '#D2D3D5',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#221F1E',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'light'
			'light' => array(
				'title'    => esc_html__( 'Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#E0DAD3',

					// Text and links colors
					'text'             => '#6B6B6B',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#F6B255',
					'text_hover'       => '#DC9B42',
					'text_link2'       => '#0868D7',
					'text_hover2'      => '#0051AF',
					'text_link3'       => '#1FA713',
					'text_hover3'      => '#118807',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FCF7F4',
					'alter_bg_hover'   => '#F1E9E4',
					'alter_bd_color'   => '#E0DAD3',
					'alter_bd_hover'   => '#C1BBB5',
					'alter_text'       => '#6B6B6B',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#F6B255',
					'alter_hover'      => '#DC9B42',
					'alter_link2'      => '#0868D7',
					'alter_hover2'     => '#0051AF',
					'alter_link3'      => '#1FA713',
					'alter_hover3'     => '#118807',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#232F3B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#35414B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D5D2D2',
					'extra_light'      => '#A09696',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#F6B255',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E0DAD3',
					'input_bd_hover'   => '#C1BBB5',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'brown_default'
			'brown_default' => array(
				'title'    => esc_html__( 'Brown Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F9EFED',
					'bd_color'         => '#DCD5D3',

					// Text and links colors
					'text'             => '#6D625F',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#C89B73',
					'text_hover'       => '#A07957',
					'text_link2'       => '#59413F',
					'text_hover2'      => '#3A2220',
					'text_link3'       => '#944B6A',
					'text_hover3'      => '#75304D',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#F0E5E2',
					'alter_bd_color'   => '#DCD5D3',
					'alter_bd_hover'   => '#CABFBD',
					'alter_text'       => '#6D625F',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#C89B73',
					'alter_hover'      => '#A07957',
					'alter_link2'      => '#59413F',
					'alter_hover2'     => '#3A2220',
					'alter_link3'      => '#944B6A',
					'alter_hover3'     => '#75304D',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#232D3B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#35404B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D2D3D5',
					'extra_light'      => '#A09896',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#C89B73',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DCD5D3',
					'input_bd_hover'   => '#CABFBD',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'brown_dark'
			'brown_dark'    => array(
				'title'    => esc_html__( 'Brown Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#191E24',
					'bd_color'         => '#35404B',

					// Text and links colors
					'text'             => '#D2D3D5',
					'text_light'       => '#9E9E9F',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#C89B73',
					'text_hover'       => '#A07957',
					'text_link2'       => '#59413F',
					'text_hover2'      => '#3A2220',
					'text_link3'       => '#944B6A',
					'text_hover3'      => '#75304D',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#212831',
					'alter_bg_hover'   => '#293345',
					'alter_bd_color'   => '#35404B',
					'alter_bd_hover'   => '#455562',
					'alter_text'       => '#D2D3D5',
					'alter_light'      => '#9E9E9F',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#C89B73',
					'alter_hover'      => '#A07957',
					'alter_link2'      => '#59413F',
					'alter_hover2'     => '#3A2220',
					'alter_link3'      => '#944B6A',
					'alter_hover3'     => '#75304D',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#232D3B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#35404B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D2D3D5',
					'extra_light'      => '#A09896',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#C89B73',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#35404B',
					'input_bd_hover'   => '#455562',
					'input_text'       => '#D2D3D5',
					'input_light'      => '#D2D3D5',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#221F1E',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'brown_light'
			'brown_light' => array(
				'title'    => esc_html__( 'Brown Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#DCD5D3',

					// Text and links colors
					'text'             => '#6D625F',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#C89B73',
					'text_hover'       => '#A07957',
					'text_link2'       => '#59413F',
					'text_hover2'      => '#3A2220',
					'text_link3'       => '#944B6A',
					'text_hover3'      => '#75304D',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F9EFED',
					'alter_bg_hover'   => '#F0E5E2',
					'alter_bd_color'   => '#DCD5D3',
					'alter_bd_hover'   => '#CABFBD',
					'alter_text'       => '#6D625F',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#C89B73',
					'alter_hover'      => '#A07957',
					'alter_link2'      => '#59413F',
					'alter_hover2'     => '#3A2220',
					'alter_link3'      => '#944B6A',
					'alter_hover3'     => '#75304D',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#232D3B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#35404B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D2D3D5',
					'extra_light'      => '#A09896',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#C89B73',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DCD5D3',
					'input_bd_hover'   => '#CABFBD',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'cinnamon_default'
			'cinnamon_default' => array(
				'title'    => esc_html__( 'Cinnamon Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FCF7F4',
					'bd_color'         => '#E0DAD3',

					// Text and links colors
					'text'             => '#6B6B6B',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#D4A693',
					'text_hover'       => '#BE9584',
					'text_link2'       => '#93C1D4',
					'text_hover2'      => '#7DADC0',
					'text_link3'       => '#DBC7C2',
					'text_hover3'      => '#C5B1AC',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#F1E9E4',
					'alter_bd_color'   => '#E0DAD3',
					'alter_bd_hover'   => '#C1BBB5',
					'alter_text'       => '#6B6B6B',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#D4A693',
					'alter_hover'      => '#BE9584',
					'alter_link2'      => '#93C1D4',
					'alter_hover2'     => '#7DADC0',
					'alter_link3'      => '#DBC7C2',
					'alter_hover3'     => '#C5B1AC',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#23293B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#353B4B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D5D2D2',
					'extra_light'      => '#A09696',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#D4A693',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E0DAD3',
					'input_bd_hover'   => '#C1BBB5',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'cinnamon_dark'
			'cinnamon_dark'    => array(
				'title'    => esc_html__( 'Cinnamon Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#142239',
					'bd_color'         => '#D2D3D5',

					// Text and links colors
					'text'             => '#D2D3D5',
					'text_light'       => '#9E9E9F',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#D4A693',
					'text_hover'       => '#BE9584',
					'text_link2'       => '#93C1D4',
					'text_hover2'      => '#7DADC0',
					'text_link3'       => '#DBC7C2',
					'text_hover3'      => '#C5B1AC',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#262E40',
					'alter_bg_hover'   => '#293145',
					'alter_bd_color'   => '#D2D3D5',
					'alter_bd_hover'   => '#454D62',
					'alter_text'       => '#D2D3D5',
					'alter_light'      => '#9E9E9F',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#D4A693',
					'alter_hover'      => '#BE9584',
					'alter_link2'      => '#93C1D4',
					'alter_hover2'     => '#7DADC0',
					'alter_link3'      => '#DBC7C2',
					'alter_hover3'     => '#C5B1AC',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#23293B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#353B4B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D5D2D2',
					'extra_light'      => '#A09696',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#D4A693',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#454D62',
					'input_text'       => '#D2D3D5',
					'input_light'      => '#D2D3D5',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#221F1E',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'cinnamon_light'
			'cinnamon_light' => array(
				'title'    => esc_html__( 'Cinnamon Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#E0DAD3',

					// Text and links colors
					'text'             => '#6B6B6B',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#D4A693',
					'text_hover'       => '#BE9584',
					'text_link2'       => '#93C1D4',
					'text_hover2'      => '#7DADC0',
					'text_link3'       => '#DBC7C2',
					'text_hover3'      => '#C5B1AC',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FCF7F4',
					'alter_bg_hover'   => '#F1E9E4',
					'alter_bd_color'   => '#E0DAD3',
					'alter_bd_hover'   => '#C1BBB5',
					'alter_text'       => '#6B6B6B',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#D4A693',
					'alter_hover'      => '#BE9584',
					'alter_link2'      => '#93C1D4',
					'alter_hover2'     => '#7DADC0',
					'alter_link3'      => '#DBC7C2',
					'alter_hover3'     => '#C5B1AC',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#23293B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#353B4B',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D5D2D2',
					'extra_light'      => '#A09696',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#D4A693',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E0DAD3',
					'input_bd_hover'   => '#C1BBB5',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'yellow_default'
			'yellow_default' => array(
				'title'    => esc_html__( 'Yellow Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FAF9F6',
					'bd_color'         => '#DCDBD3',

					// Text and links colors
					'text'             => '#6B6B6B',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#E8B500',
					'text_hover'       => '#CFA202',
					'text_link2'       => '#E84100',
					'text_hover2'      => '#C53700',
					'text_link3'       => '#0231D6',
					'text_hover3'      => '#022AB9',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#ffffff',
					'alter_bg_hover'   => '#F0EEE2',
					'alter_bd_color'   => '#DCDBD3',
					'alter_bd_hover'   => '#CAC8BD',
					'alter_text'       => '#6B6B6B',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#E8B500',
					'alter_hover'      => '#CFA202',
					'alter_link2'      => '#E84100',
					'alter_hover2'     => '#C53700',
					'alter_link3'      => '#0231D6',
					'alter_hover3'     => '#022AB9',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#2A2A31',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#40424D',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D2D3D5',
					'extra_light'      => '#A09D96',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#E8B500',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DCDBD3',
					'input_bd_hover'   => '#CAC8BD',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'yellow_dark'
			'yellow_dark'    => array(
				'title'    => esc_html__( 'Yellow Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0B0C14',
					'bd_color'         => '#40424D',

					// Text and links colors
					'text'             => '#D2D3D5',
					'text_light'       => '#9E9E9F',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#E8B500',
					'text_hover'       => '#CFA202',
					'text_link2'       => '#E84100',
					'text_hover2'      => '#C53700',
					'text_link3'       => '#0231D6',
					'text_hover3'      => '#022AB9',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#17191E',
					'alter_bg_hover'   => '#373843',
					'alter_bd_color'   => '#40424D',
					'alter_bd_hover'   => '#595A60',
					'alter_text'       => '#D2D3D5',
					'alter_light'      => '#9E9E9F',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#E8B500',
					'alter_hover'      => '#CFA202',
					'alter_link2'      => '#E84100',
					'alter_hover2'     => '#C53700',
					'alter_link3'      => '#0231D6',
					'alter_hover3'     => '#022AB9',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#2A2A31',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#40424D',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D2D3D5',
					'extra_light'      => '#A09D96',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#E8B500',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#595A60',
					'input_text'       => '#D2D3D5',
					'input_light'      => '#D2D3D5',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#221F1E',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'yellow_light'
			'yellow_light' => array(
				'title'    => esc_html__( 'Yellow Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#ffffff',
					'bd_color'         => '#DCDBD3',

					// Text and links colors
					'text'             => '#6B6B6B',
					'text_light'       => '#A5A5A5',
					'text_dark'        => '#221F1E',
					'text_link'        => '#E8B500',
					'text_hover'       => '#CFA202',
					'text_link2'       => '#E84100',
					'text_hover2'      => '#C53700',
					'text_link3'       => '#0231D6',
					'text_hover3'      => '#022AB9',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FAF9F6',
					'alter_bg_hover'   => '#F0EEE2',
					'alter_bd_color'   => '#DCDBD3',
					'alter_bd_hover'   => '#CAC8BD',
					'alter_text'       => '#6B6B6B',
					'alter_light'      => '#A5A5A5',
					'alter_dark'       => '#221F1E',
					'alter_link'       => '#E8B500',
					'alter_hover'      => '#CFA202',
					'alter_link2'      => '#E84100',
					'alter_hover2'     => '#C53700',
					'alter_link3'      => '#0231D6',
					'alter_hover3'     => '#022AB9',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#2A2A31',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#40424D',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#D2D3D5',
					'extra_light'      => '#A09D96',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#E8B500',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DCDBD3',
					'input_bd_hover'   => '#CAC8BD',
					'input_text'       => '#A5A5A5',
					'input_light'      => '#A5A5A5',
					'input_dark'       => '#221F1E',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#221F1E',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'feldspar_default'
			'feldspar_default' => array(
				'title'    => esc_html__( 'Feldspar Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F3EEE7',
					'bd_color'         => '#EFE4D4',

					// Text and links colors
					'text'             => '#7A7979',
					'text_light'       => '#AAAAAA',
					'text_dark'        => '#392B25',
					'text_link'        => '#D6A680',
					'text_hover'       => '#C28E64',
					'text_link2'       => '#757B67',
					'text_hover2'      => '#636A54',
					'text_link3'       => '#8E80D6',
					'text_hover3'      => '#6758B4',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FAF6F2',
					'alter_bg_hover'   => '#F1EAE0',
					'alter_bd_color'   => '#EFE4D4',
					'alter_bd_hover'   => '#E3D5BF',
					'alter_text'       => '#7A7979',
					'alter_light'      => '#AAAAAA',
					'alter_dark'       => '#392B25',
					'alter_link'       => '#D6A680',
					'alter_hover'      => '#C28E64',
					'alter_link2'      => '#757B67',
					'alter_hover2'     => '#636A54',
					'alter_link3'      => '#8E80D6',
					'alter_hover3'     => '#6758B4',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#362716',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#3E3D39',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#B4B4B4',
					'extra_light'      => '#959595',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#D6A680',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#EFE4D4',
					'input_bd_hover'   => '#E3D5BF',
					'input_text'       => '#AAAAAA',
					'input_light'      => '#AAAAAA',
					'input_dark'       => '#392B25',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'feldspar_dark'
			'feldspar_dark'    => array(
				'title'    => esc_html__( 'Feldspar Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#161514',
					'bd_color'         => '#3E3D39',

					// Text and links colors
					'text'             => '#B4B4B4',
					'text_light'       => '#959595',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#D6A680',
					'text_hover'       => '#C28E64',
					'text_link2'       => '#757B67',
					'text_hover2'      => '#636A54',
					'text_link3'       => '#8E80D6',
					'text_hover3'      => '#6758B4',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#272624',
					'alter_bg_hover'   => '#191815',
					'alter_bd_color'   => '#3E3D39',
					'alter_bd_hover'   => '#4E4D49',
					'alter_text'       => '#B4B4B4',
					'alter_light'      => '#959595',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#D6A680',
					'alter_hover'      => '#C28E64',
					'alter_link2'      => '#757B67',
					'alter_hover2'     => '#636A54',
					'alter_link3'      => '#8E80D6',
					'alter_hover3'     => '#6758B4',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#362716',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#3E3D39',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#B4B4B4',
					'extra_light'      => '#959595',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#D6A680',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#4E4D49',
					'input_text'       => '#B4B4B4',
					'input_light'      => '#B4B4B4',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#392B25',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'feldspar_light'
			'feldspar_light' => array(
				'title'    => esc_html__( 'Feldspar Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FAF6F2',
					'bd_color'         => '#EFE4D4',

					// Text and links colors
					'text'             => '#7A7979',
					'text_light'       => '#AAAAAA',
					'text_dark'        => '#392B25',
					'text_link'        => '#D6A680',
					'text_hover'       => '#C28E64',
					'text_link2'       => '#757B67',
					'text_hover2'      => '#636A54',
					'text_link3'       => '#8E80D6',
					'text_hover3'      => '#6758B4',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F3EEE7',
					'alter_bg_hover'   => '#F1EAE0',
					'alter_bd_color'   => '#EFE4D4',
					'alter_bd_hover'   => '#E3D5BF',
					'alter_text'       => '#7A7979',
					'alter_light'      => '#AAAAAA',
					'alter_dark'       => '#392B25',
					'alter_link'       => '#D6A680',
					'alter_hover'      => '#C28E64',
					'alter_link2'      => '#757B67',
					'alter_hover2'     => '#636A54',
					'alter_link3'      => '#8E80D6',
					'alter_hover3'     => '#6758B4',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#362716',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#3E3D39',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#B4B4B4',
					'extra_light'      => '#959595',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#D6A680',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#EFE4D4',
					'input_bd_hover'   => '#E3D5BF',
					'input_text'       => '#AAAAAA',
					'input_light'      => '#AAAAAA',
					'input_dark'       => '#392B25',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'orange_default'
			'orange_default' => array(
				'title'    => esc_html__( 'Orange Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F2F2F2',
					'bd_color'         => '#DEDEDE',

					// Text and links colors
					'text'             => '#7A7979',
					'text_light'       => '#AAAAAA',
					'text_dark'        => '#392B25',
					'text_link'        => '#F25A2A',
					'text_hover'       => '#E24615',
					'text_link2'       => '#2A66F2',
					'text_hover2'      => '#0E4CDE',
					'text_link3'       => '#F22A4C',
					'text_hover3'      => '#D9092C',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FBFBFB',
					'alter_bg_hover'   => '#E5E5E5',
					'alter_bd_color'   => '#DEDEDE',
					'alter_bd_hover'   => '#D4D4D4',
					'alter_text'       => '#7A7979',
					'alter_light'      => '#AAAAAA',
					'alter_dark'       => '#392B25',
					'alter_link'       => '#F25A2A',
					'alter_hover'      => '#E24615',
					'alter_link2'      => '#2A66F2',
					'alter_hover2'     => '#0E4CDE',
					'alter_link3'      => '#F22A4C',
					'alter_hover3'     => '#D9092C',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#3E1717',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#672C2C',
					'extra_bd_hover'   => '#773E3E',
					'extra_text'       => '#ABAAAA',
					'extra_light'      => '#8B8582',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#F25A2A',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DEDEDE',
					'input_bd_hover'   => '#D4D4D4',
					'input_text'       => '#AAAAAA',
					'input_light'      => '#AAAAAA',
					'input_dark'       => '#392B25',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'orange_dark'
			'orange_dark'    => array(
				'title'    => esc_html__( 'Orange Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#161515',
					'bd_color'         => '#393939',

					// Text and links colors
					'text'             => '#ABAAAA',
					'text_light'       => '#8B8582',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#F25A2A',
					'text_hover'       => '#E24615',
					'text_link2'       => '#2A66F2',
					'text_hover2'      => '#0E4CDE',
					'text_link3'       => '#F22A4C',
					'text_hover3'      => '#D9092C',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#2E2D2D',
					'alter_bg_hover'   => '#262525',
					'alter_bd_color'   => '#393939',
					'alter_bd_hover'   => '#4A4A4A',
					'alter_text'       => '#ABAAAA',
					'alter_light'      => '#8B8582',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#F25A2A',
					'alter_hover'      => '#E24615',
					'alter_link2'      => '#2A66F2',
					'alter_hover2'     => '#0E4CDE',
					'alter_link3'      => '#F22A4C',
					'alter_hover3'     => '#D9092C',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#3E1717',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#672C2C',
					'extra_bd_hover'   => '#773E3E',
					'extra_text'       => '#ABAAAA',
					'extra_light'      => '#8B8582',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#F25A2A',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#4A4A4A',
					'input_text'       => '#ABAAAA',
					'input_light'      => '#ABAAAA',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#392B25',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'orange_light'
			'orange_light' => array(
				'title'    => esc_html__( 'Orange Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FBFBFB',
					'bd_color'         => '#DEDEDE',

					// Text and links colors
					'text'             => '#7A7979',
					'text_light'       => '#AAAAAA',
					'text_dark'        => '#392B25',
					'text_link'        => '#F25A2A',
					'text_hover'       => '#E24615',
					'text_link2'       => '#2A66F2',
					'text_hover2'      => '#0E4CDE',
					'text_link3'       => '#F22A4C',
					'text_hover3'      => '#D9092C',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F2F2F2',
					'alter_bg_hover'   => '#E5E5E5',
					'alter_bd_color'   => '#DEDEDE',
					'alter_bd_hover'   => '#D4D4D4',
					'alter_text'       => '#7A7979',
					'alter_light'      => '#AAAAAA',
					'alter_dark'       => '#392B25',
					'alter_link'       => '#F25A2A',
					'alter_hover'      => '#E24615',
					'alter_link2'      => '#2A66F2',
					'alter_hover2'     => '#0E4CDE',
					'alter_link3'      => '#F22A4C',
					'alter_hover3'     => '#D9092C',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#3E1717',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#672C2C',
					'extra_bd_hover'   => '#773E3E',
					'extra_text'       => '#ABAAAA',
					'extra_light'      => '#8B8582',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#F25A2A',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DEDEDE',
					'input_bd_hover'   => '#D4D4D4',
					'input_text'       => '#AAAAAA',
					'input_light'      => '#AAAAAA',
					'input_dark'       => '#392B25',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'gold_default'
			'gold_default' => array(
				'title'    => esc_html__( 'Gold Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F6F3ED',
					'bd_color'         => '#DCD4C2',

					// Text and links colors
					'text'             => '#7A7979',
					'text_light'       => '#AAAAAA',
					'text_dark'        => '#392B25',
					'text_link'        => '#AC845D',
					'text_hover'       => '#916942',
					'text_link2'       => '#AC6756',
					'text_hover2'      => '#9F5A49',
					'text_link3'       => '#569AAC',
					'text_hover3'      => '#41889B',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FBFBFB',
					'alter_bg_hover'   => '#F6F1E6',
					'alter_bd_color'   => '#DCD4C2',
					'alter_bd_hover'   => '#D5CAB2',
					'alter_text'       => '#7A7979',
					'alter_light'      => '#AAAAAA',
					'alter_dark'       => '#392B25',
					'alter_link'       => '#AC845D',
					'alter_hover'      => '#916942',
					'alter_link2'      => '#AC6756',
					'alter_hover2'     => '#9F5A49',
					'alter_link3'      => '#569AAC',
					'alter_hover3'     => '#41889B',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#483A34',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#69544B',
					'extra_bd_hover'   => '#7D665C',
					'extra_text'       => '#ABAAAA',
					'extra_light'      => '#8B8582',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#AC845D',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DCD4C2',
					'input_bd_hover'   => '#D5CAB2',
					'input_text'       => '#AAAAAA',
					'input_light'      => '#AAAAAA',
					'input_dark'       => '#392B25',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'gold_dark'
			'gold_dark'    => array(
				'title'    => esc_html__( 'Gold Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#0D0C0C',
					'bd_color'         => '#393939',

					// Text and links colors
					'text'             => '#ABAAAA',
					'text_light'       => '#8B8582',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#AC845D',
					'text_hover'       => '#916942',
					'text_link2'       => '#AC6756',
					'text_hover2'      => '#9F5A49',
					'text_link3'       => '#569AAC',
					'text_hover3'      => '#41889B',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#191616',
					'alter_bg_hover'   => '#292525',
					'alter_bd_color'   => '#393939',
					'alter_bd_hover'   => '#393939',
					'alter_text'       => '#ABAAAA',
					'alter_light'      => '#8B8582',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#AC845D',
					'alter_hover'      => '#916942',
					'alter_link2'      => '#AC6756',
					'alter_hover2'     => '#9F5A49',
					'alter_link3'      => '#569AAC',
					'alter_hover3'     => '#41889B',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#483A34',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#69544B',
					'extra_bd_hover'   => '#7D665C',
					'extra_text'       => '#ABAAAA',
					'extra_light'      => '#8B8582',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#AC845D',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#4A4A4A',
					'input_text'       => '#ABAAAA',
					'input_light'      => '#ABAAAA',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#392B25',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'gold_light'
			'gold_light' => array(
				'title'    => esc_html__( 'Gold Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FBFBFB',
					'bd_color'         => '#DCD4C2',

					// Text and links colors
					'text'             => '#7A7979',
					'text_light'       => '#AAAAAA',
					'text_dark'        => '#392B25',
					'text_link'        => '#AC845D',
					'text_hover'       => '#916942',
					'text_link2'       => '#AC6756',
					'text_hover2'      => '#9F5A49',
					'text_link3'       => '#569AAC',
					'text_hover3'      => '#41889B',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F6F3ED',
					'alter_bg_hover'   => '#F6F1E6',
					'alter_bd_color'   => '#DCD4C2',
					'alter_bd_hover'   => '#D5CAB2',
					'alter_text'       => '#7A7979',
					'alter_light'      => '#AAAAAA',
					'alter_dark'       => '#392B25',
					'alter_link'       => '#AC845D',
					'alter_hover'      => '#916942',
					'alter_link2'      => '#AC6756',
					'alter_hover2'     => '#9F5A49',
					'alter_link3'      => '#569AAC',
					'alter_hover3'     => '#41889B',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#483A34',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#69544B',
					'extra_bd_hover'   => '#7D665C',
					'extra_text'       => '#ABAAAA',
					'extra_light'      => '#8B8582',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#AC845D',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DCD4C2',
					'input_bd_hover'   => '#D5CAB2',
					'input_text'       => '#AAAAAA',
					'input_light'      => '#AAAAAA',
					'input_dark'       => '#392B25',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#392B25',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
			
			// Color scheme: 'lilac_default'
			'lilac_default' => array(
				'title'    => esc_html__( 'Lilac Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFF4F0',
					'bd_color'         => '#F2D7CD',

					// Text and links colors
					'text'             => '#9B8E89',
					'text_light'       => '#D2C4BF',
					'text_dark'        => '#171615',
					'text_link'        => '#FB308F',
					'text_hover'       => '#E60971',
					'text_link2'       => '#9BCF34',
					'text_hover2'      => '#83BB15',
					'text_link3'       => '#F79029',
					'text_hover3'      => '#EF7A04',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FBFBFB',
					'alter_bg_hover'   => '#FFEDE6',
					'alter_bd_color'   => '#F2D7CD',
					'alter_bd_hover'   => '#E9D0C7',
					'alter_text'       => '#9B8E89',
					'alter_light'      => '#D2C4BF',
					'alter_dark'       => '#171615',
					'alter_link'       => '#FB308F',
					'alter_hover'      => '#E60971',
					'alter_link2'      => '#9BCF34',
					'alter_hover2'     => '#83BB15',
					'alter_link3'      => '#F79029',
					'alter_hover3'     => '#EF7A04',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#302C29',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#484542',
					'extra_bd_hover'   => '#585450',
					'extra_text'       => '#B5B0AE',
					'extra_light'      => '#918581',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#FB308F',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#F2D7CD',
					'input_bd_hover'   => '#E9D0C7',
					'input_text'       => '#D2C4BF',
					'input_light'      => '#D2C4BF',
					'input_dark'       => '#171615',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#171615',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'lilac_dark'
			'lilac_dark'    => array(
				'title'    => esc_html__( 'Lilac Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#272524',
					'bd_color'         => '#373230',

					// Text and links colors
					'text'             => '#B5B0AE',
					'text_light'       => '#918581',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#FB308F',
					'text_hover'       => '#E60971',
					'text_link2'       => '#9BCF34',
					'text_hover2'      => '#83BB15',
					'text_link3'       => '#F79029',
					'text_hover3'      => '#EF7A04',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1A1716',
					'alter_bg_hover'   => '#292625',
					'alter_bd_color'   => '#373230',
					'alter_bd_hover'   => '#53535C',
					'alter_text'       => '#B5B0AE',
					'alter_light'      => '#918581',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#FB308F',
					'alter_hover'      => '#E60971',
					'alter_link2'      => '#9BCF34',
					'alter_hover2'     => '#83BB15',
					'alter_link3'      => '#F79029',
					'alter_hover3'     => '#EF7A04',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#302C29',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#484542',
					'extra_bd_hover'   => '#585450',
					'extra_text'       => '#B5B0AE',
					'extra_light'      => '#918581',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#FB308F',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#484341',
					'input_text'       => '#B5B0AE',
					'input_light'      => '#B5B0AE',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#1A1716',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#171615',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#171615',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'lilac_light'
			'lilac_light' => array(
				'title'    => esc_html__( 'Lilac Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FBFBFB',
					'bd_color'         => '#F2D7CD',

					// Text and links colors
					'text'             => '#9B8E89',
					'text_light'       => '#D2C4BF',
					'text_dark'        => '#171615',
					'text_link'        => '#FB308F',
					'text_hover'       => '#E60971',
					'text_link2'       => '#9BCF34',
					'text_hover2'      => '#83BB15',
					'text_link3'       => '#F79029',
					'text_hover3'      => '#EF7A04',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFF4F0',
					'alter_bg_hover'   => '#FFEDE6',
					'alter_bd_color'   => '#F2D7CD',
					'alter_bd_hover'   => '#E9D0C7',
					'alter_text'       => '#9B8E89',
					'alter_light'      => '#D2C4BF',
					'alter_dark'       => '#171615',
					'alter_link'       => '#FB308F',
					'alter_hover'      => '#E60971',
					'alter_link2'      => '#9BCF34',
					'alter_hover2'     => '#83BB15',
					'alter_link3'      => '#F79029',
					'alter_hover3'     => '#EF7A04',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#302C29',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#484542',
					'extra_bd_hover'   => '#585450',
					'extra_text'       => '#B5B0AE',
					'extra_light'      => '#918581',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#FB308F',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#F2D7CD',
					'input_bd_hover'   => '#E9D0C7',
					'input_text'       => '#D2C4BF',
					'input_light'      => '#D2C4BF',
					'input_dark'       => '#171615',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#171615',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'pink_default'
			'pink_default' => array(
				'title'    => esc_html__( 'Pink Default', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#EDF6FF',
					'bd_color'         => '#CDDDEE',

					// Text and links colors
					'text'             => '#5E6267',
					'text_light'       => '#A0A8B1',
					'text_dark'        => '#1E2021',
					'text_link'        => '#5188F9',
					'text_hover'       => '#346FE9',
					'text_link2'       => '#F58599',
					'text_hover2'      => '#EC6B82',
					'text_link3'       => '#11D5D2',
					'text_hover3'      => '#0BC9C6',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FBFBFB',
					'alter_bg_hover'   => '#E2EFFC',
					'alter_bd_color'   => '#CDDDEE',
					'alter_bd_hover'   => '#B7CFE8',
					'alter_text'       => '#5E6267',
					'alter_light'      => '#A0A8B1',
					'alter_dark'       => '#1E2021',
					'alter_link'       => '#5188F9',
					'alter_hover'      => '#346FE9',
					'alter_link2'      => '#F58599',
					'alter_hover2'     => '#EC6B82',
					'alter_link3'      => '#11D5D2',
					'alter_hover3'     => '#0BC9C6',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#23253B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373D43',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#BABFC4',
					'extra_light'      => '#82868A',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#5188F9',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#CDDDEE',
					'input_bd_hover'   => '#B7CFE8',
					'input_text'       => '#A0A8B1',
					'input_light'      => '#A0A8B1',
					'input_dark'       => '#1E2021',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1E2021',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'pink_dark'
			'pink_dark'    => array(
				'title'    => esc_html__( 'Pink Dark', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#161617',
					'bd_color'         => '#373D43',

					// Text and links colors
					'text'             => '#BABFC4',
					'text_light'       => '#82868A',
					'text_dark'        => '#FCFCFC',
					'text_link'        => '#5188F9',
					'text_hover'       => '#346FE9',
					'text_link2'       => '#F58599',
					'text_hover2'      => '#EC6B82',
					'text_link3'       => '#11D5D2',
					'text_hover3'      => '#0BC9C6',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#1C1E20',
					'alter_bg_hover'   => '#25272A',
					'alter_bd_color'   => '#373D43',
					'alter_bd_hover'   => '#41484E',
					'alter_text'       => '#BABFC4',
					'alter_light'      => '#82868A',
					'alter_dark'       => '#FCFCFC',
					'alter_link'       => '#5188F9',
					'alter_hover'      => '#346FE9',
					'alter_link2'      => '#F58599',
					'alter_hover2'     => '#EC6B82',
					'alter_link3'      => '#11D5D2',
					'alter_hover3'     => '#0BC9C6',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#23253B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373D43',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#BABFC4',
					'extra_light'      => '#82868A',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#5188F9',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#353B4B',
					'input_bd_hover'   => '#41484E',
					'input_text'       => '#BABFC4',
					'input_light'      => '#BABFC4',
					'input_dark'       => '#FCFCFC',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FCFCFC',
					'inverse_bd_hover' => '#1C1E20',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1E2021',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#1E2021',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'pink_light'
			'pink_light' => array(
				'title'    => esc_html__( 'Pink Light', 'eventicity' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FBFBFB',
					'bd_color'         => '#CDDDEE',

					// Text and links colors
					'text'             => '#5E6267',
					'text_light'       => '#A0A8B1',
					'text_dark'        => '#1E2021',
					'text_link'        => '#5188F9',
					'text_hover'       => '#346FE9',
					'text_link2'       => '#F58599',
					'text_hover2'      => '#EC6B82',
					'text_link3'       => '#11D5D2',
					'text_hover3'      => '#0BC9C6',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#EDF6FF',
					'alter_bg_hover'   => '#E2EFFC',
					'alter_bd_color'   => '#CDDDEE',
					'alter_bd_hover'   => '#B7CFE8',
					'alter_text'       => '#5E6267',
					'alter_light'      => '#A0A8B1',
					'alter_dark'       => '#1E2021',
					'alter_link'       => '#5188F9',
					'alter_hover'      => '#346FE9',
					'alter_link2'      => '#F58599',
					'alter_hover2'     => '#EC6B82',
					'alter_link3'      => '#11D5D2',
					'alter_hover3'     => '#0BC9C6',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#23253B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#373D43',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#BABFC4',
					'extra_light'      => '#82868A',
					'extra_dark'       => '#FCFCFC',
					'extra_link'       => '#5188F9',
					'extra_hover'      => '#FCFCFC',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#CDDDEE',
					'input_bd_hover'   => '#B7CFE8',
					'input_text'       => '#A0A8B1',
					'input_light'      => '#A0A8B1',
					'input_dark'       => '#1E2021',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#D2D3D5',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1E2021',
					'inverse_link'     => '#FCFCFC',
					'inverse_hover'    => '#FCFCFC',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),
		);
		eventicity_storage_set( 'schemes', $schemes );
		eventicity_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> eventicity_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'eventicity' ),
		//---> 	'description' => __( 'Description of the new color 1', 'eventicity' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		eventicity_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_08' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.8,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_dark_015'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.15,
				),
				'alter_dark_02'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.2,
				),
				'alter_dark_05'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.5,
				),
				'alter_dark_08'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.8,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_003'      => array(
					'color' => 'text_dark',
					'alpha' => 0.03,
				),
				'text_dark_005'      => array(
					'color' => 'text_dark',
					'alpha' => 0.05,
				),
				'text_dark_008'      => array(
					'color' => 'text_dark',
					'alpha' => 0.08,
				),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
				'text_dark_03'      => array(
					'color' => 'text_dark',
					'alpha' => 0.3,
				),
				'text_dark_05'      => array(
					'color' => 'text_dark',
					'alpha' => 0.5,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'text_dark_08'      => array(
					'color' => 'text_dark',
					'alpha' => 0.8,
				),
				'text_link_007'      => array(
					'color' => 'text_link',
					'alpha' => 0.07,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_03'      => array(
					'color' => 'text_link',
					'alpha' => 0.3,
				),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
					'color' => 'text_link2',
					'alpha' => 0.8,
				),
				'text_link2_007'      => array(
					'color' => 'text_link2',
					'alpha' => 0.07,
				),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
				'text_link2_03'      => array(
					'color' => 'text_link2',
					'alpha' => 0.3,
				),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
				'text_link3_007'      => array(
					'color' => 'text_link3',
					'alpha' => 0.07,
				),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
				'text_link3_03'      => array(
					'color' => 'text_link3',
					'alpha' => 0.3,
				),
				'inverse_text_03'      => array(
					'color' => 'inverse_text',
					'alpha' => 0.3,
				),
				'inverse_link_08'      => array(
					'color' => 'inverse_link',
					'alpha' => 0.8,
				),
				'inverse_hover_08'      => array(
					'color' => 'inverse_hover',
					'alpha' => 0.8,
				),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		eventicity_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		eventicity_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		eventicity_storage_set(
					'color_presets', array(
					'autumn' => array(
					'title'  => esc_html__( 'Autumn', 'eventicity' ),
						'colors' => array(
						'default' => array(
							'text_link'  => '#d83938',
							'text_hover' => '#f2b232',
							),
						'dark' => array(
							'text_link'  => '#d83938',
							'text_hover' => '#f2b232',
							)
						)
					),
					'green' => array(
						'title'  => esc_html__( 'Natural Green', 'eventicity' ),
						'colors' => array(
						'default' => array(
							'text_link'  => '#75ac78',
							'text_hover' => '#378e6d',
						),
						'dark' => array(
							'text_link'  => '#75ac78',
							'text_hover' => '#378e6d',
						)
					)
				),
			)
		);
	}
}

// Background selection option
// 3 - add/remove Theme Options elements
if ( ! function_exists( 'eventicity_clone_skin_theme_setup3' ) ) {
	add_action( 'after_setup_theme', 'eventicity_clone_skin_theme_setup3', 3 );
	function eventicity_clone_skin_theme_setup3() {
		eventicity_storage_set_array_after( 'options', 'remove_margins', array(
			'extra_bg_image' => array(
				"title" => esc_html__('Extra background image', 'eventicity'),
				"desc" => wp_kses_data( __('Select or upload background-image to display it in the page. Does not work for boxed body style.', 'eventicity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'eventicity')
				),
				'dependency' => array(
					'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
				),
				"std" => '',
				'pro_only'   => EVENTICITY_THEME_FREE,
				"type" => "image"
			),
			'extra_bg_image_size' => array(
				"title" => esc_html__('Extra background image size', 'eventicity'),
				"desc" => wp_kses_data( __('Use size contain (cover original).', 'eventicity') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'eventicity')
				),
				'dependency' => array(
					'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
				),
				"std" => 0,
				'pro_only'   => EVENTICITY_THEME_FREE,
				"type" => "switch"
			),
			'extra_bg_image_fixed' => array(
				'title' => esc_html__('Extra background attachment', 'eventicity'),
				'desc' => wp_kses_data( __('Enable fixed position of the background image', 'eventicity') ),
				'std' => 0,
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'eventicity')
				),
				'dependency' => array(
					'body_style' => array( 'wide', 'fullwide', 'fullscreen' ),
				),
				'pro_only'   => EVENTICITY_THEME_FREE,
				'type' => 'switch'
			),
			)
		);
	}
}

if ( ! function_exists( 'eventicity_skin_filter_page_wrap_class' ) ) {
    add_action('eventicity_filter_page_wrap_class', 'eventicity_skin_filter_page_wrap_class');
	function eventicity_skin_filter_page_wrap_class($class) {
		$extra_bg_image = eventicity_get_theme_option('extra_bg_image');
		$extra_bg_image_size = eventicity_is_on(eventicity_get_theme_option('extra_bg_image_size'));
		$extra_bg_image_fixed = eventicity_is_on(eventicity_get_theme_option('extra_bg_image_fixed'));
		$body_boxed_style = eventicity_get_theme_option( 'body_style' ) == 'boxed';
		if (!empty( $extra_bg_image ) && !$body_boxed_style ) {
			$custom_bg = ' ' . 'with_bg' .($extra_bg_image_size ? ' contain_size ' : ''). ' ' .($extra_bg_image_fixed ? ' fixed ' : ''). eventicity_add_inline_css_class('background-image: url(' . esc_url($extra_bg_image) . ');');
			$class = $class . $custom_bg;
		}
		return $class;
	}
}
// Add div with fixed background
if ( ! function_exists( 'eventicity_skin_custom_bg_layout' ) ) {
    add_action('eventicity_action_page_wrap_start', 'eventicity_skin_custom_bg_layout');
    function eventicity_skin_custom_bg_layout() {
		$extra_bg_image = eventicity_get_theme_option('extra_bg_image');
        $extra_bg_image_size = eventicity_is_on(eventicity_get_theme_option('extra_bg_image_size'));
        $extra_bg_image_fixed = eventicity_is_on(eventicity_get_theme_option('extra_bg_image_fixed'));
        $body_boxed_style = eventicity_get_theme_option( 'body_style' ) == 'boxed';
		if (!empty( $extra_bg_image ) && !$body_boxed_style && $extra_bg_image_fixed) {
            $custom_bg = ($extra_bg_image_size ? ' contain_size ' : ''). ' ' . eventicity_add_inline_css_class('background-image: url(' . esc_url($extra_bg_image) . ');');
			?>
				<div class="custom_bg_fixed <?php echo esc_attr($custom_bg); ?>"></div>
			<?php
		}
    }
}

//Enqueue skin-specific scripts
if ( ! function_exists( 'eventicity_skin_upgrade_style' ) ) {
	add_action( 'wp_enqueue_scripts', 'eventicity_skin_upgrade_style', 2060 );
	function eventicity_skin_upgrade_style() {
		$eventicity_url = eventicity_get_file_url( eventicity_skins_get_current_skin_dir() . 'skin-upgrade-style.css' );
		if ( '' != $eventicity_url ) {
			wp_enqueue_style( 'eventicity-skin-upgrade-style' . esc_attr( eventicity_skins_get_current_skin_name() ), $eventicity_url, array(), null );
		}
		$eventicity_url = eventicity_get_file_url( eventicity_skins_get_current_skin_dir() . 'without-shadow-upgrade-style.css' );
		if ( '' != $eventicity_url ) {
			wp_enqueue_style( 'eventicity-without-shadow-upgrade-style' . esc_attr( eventicity_skins_get_current_skin_name() ), $eventicity_url, array(), null );
		}
	}
}

// Activation methods
if ( ! function_exists( 'eventicity_skin_filter_activation_methods2' ) ) {
	add_filter( 'trx_addons_filter_activation_methods', 'eventicity_skin_filter_activation_methods2', 11, 1 );
	function eventicity_skin_filter_activation_methods2( $args ) {
		$args['elements_key'] = true;
		return $args;
	}
}