<?php
/**
 * The template to display single post
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

// Full post loading
$full_post_loading          = eventicity_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = eventicity_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = eventicity_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$eventicity_related_position   = eventicity_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$eventicity_posts_navigation   = eventicity_get_theme_option( 'posts_navigation' );
$eventicity_prev_post          = false;
$eventicity_prev_post_same_cat = (int)eventicity_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( eventicity_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	eventicity_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'eventicity_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $eventicity_posts_navigation ) {
		$eventicity_prev_post = get_previous_post( $eventicity_prev_post_same_cat );  // Get post from same category
		if ( ! $eventicity_prev_post && $eventicity_prev_post_same_cat ) {
			$eventicity_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $eventicity_prev_post ) {
			$eventicity_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $eventicity_prev_post ) ) {
		eventicity_sc_layouts_showed( 'featured', false );
		eventicity_sc_layouts_showed( 'title', false );
		eventicity_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $eventicity_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/content', 'single-' . eventicity_get_theme_option( 'single_style' ) ), 'single-' . eventicity_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $eventicity_related_position, 'inside' ) === 0 ) {
		$eventicity_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'eventicity_action_related_posts' );
		$eventicity_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $eventicity_related_content ) ) {
			$eventicity_related_position_inside = max( 0, min( 9, eventicity_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $eventicity_related_position_inside ) {
				$eventicity_related_position_inside = mt_rand( 1, 9 );
			}

			$eventicity_p_number         = 0;
			$eventicity_related_inserted = false;
			$eventicity_in_block         = false;
			$eventicity_content_start    = strpos( $eventicity_content, '<div class="post_content' );
			$eventicity_content_end      = strrpos( $eventicity_content, '</div>' );

			for ( $i = max( 0, $eventicity_content_start ); $i < min( strlen( $eventicity_content ) - 3, $eventicity_content_end ); $i++ ) {
				if ( $eventicity_content[ $i ] != '<' ) {
					continue;
				}
				if ( $eventicity_in_block ) {
					if ( strtolower( substr( $eventicity_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$eventicity_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $eventicity_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $eventicity_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$eventicity_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $eventicity_content[ $i + 1 ] && in_array( $eventicity_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$eventicity_p_number++;
					if ( $eventicity_related_position_inside == $eventicity_p_number ) {
						$eventicity_related_inserted = true;
						$eventicity_content = ( $i > 0 ? substr( $eventicity_content, 0, $i ) : '' )
											. $eventicity_related_content
											. substr( $eventicity_content, $i );
					}
				}
			}
			if ( ! $eventicity_related_inserted ) {
				if ( $eventicity_content_end > 0 ) {
					$eventicity_content = substr( $eventicity_content, 0, $eventicity_content_end ) . $eventicity_related_content . substr( $eventicity_content, $eventicity_content_end );
				} else {
					$eventicity_content .= $eventicity_related_content;
				}
			}
		}

		eventicity_show_layout( $eventicity_content );
	}

	// Comments
	do_action( 'eventicity_action_before_comments' );
	comments_template();
	do_action( 'eventicity_action_after_comments' );

	// Related posts
	if ( 'below_content' == $eventicity_related_position
		&& ( 'scroll' != $eventicity_posts_navigation || (int)eventicity_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)eventicity_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'eventicity_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $eventicity_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $eventicity_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $eventicity_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $eventicity_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'eventicity_action_nav_links_single_scroll_data', $eventicity_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
