<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

if ( eventicity_sidebar_present() ) {
	
	$eventicity_sidebar_type = eventicity_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $eventicity_sidebar_type && ! eventicity_is_layouts_available() ) {
		$eventicity_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $eventicity_sidebar_type ) {
		// Default sidebar with widgets
		$eventicity_sidebar_name = eventicity_get_theme_option( 'sidebar_widgets' );
		eventicity_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $eventicity_sidebar_name ) ) {
			dynamic_sidebar( $eventicity_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$eventicity_sidebar_id = eventicity_get_custom_sidebar_id();
		do_action( 'eventicity_action_show_layout', $eventicity_sidebar_id );
	}
	$eventicity_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $eventicity_out ) ) {
		$eventicity_sidebar_position    = eventicity_get_theme_option( 'sidebar_position' );
		$eventicity_sidebar_position_ss = eventicity_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $eventicity_sidebar_position );
			echo ' sidebar_' . esc_attr( $eventicity_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $eventicity_sidebar_type );

			$eventicity_sidebar_scheme = apply_filters( 'eventicity_filter_sidebar_scheme', eventicity_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $eventicity_sidebar_scheme ) && ! eventicity_is_inherit( $eventicity_sidebar_scheme ) && 'custom' != $eventicity_sidebar_type ) {
				echo ' scheme_' . esc_attr( $eventicity_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="eventicity_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'eventicity_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $eventicity_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$eventicity_title = apply_filters( 'eventicity_filter_sidebar_control_title', 'float' == $eventicity_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'eventicity' ) : '' );
				$eventicity_text  = apply_filters( 'eventicity_filter_sidebar_control_text', 'above' == $eventicity_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'eventicity' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $eventicity_title ); ?>"><?php echo esc_html( $eventicity_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'eventicity_action_before_sidebar', 'sidebar' );
				eventicity_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $eventicity_out ) );
				do_action( 'eventicity_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'eventicity_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
