<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

$eventicity_template = apply_filters( 'eventicity_filter_get_template_part', eventicity_blog_archive_get_template() );

if ( ! empty( $eventicity_template ) && 'index' != $eventicity_template ) {

	get_template_part( $eventicity_template );

} else {

	eventicity_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$eventicity_stickies   = is_home()
								|| ( in_array( eventicity_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) eventicity_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$eventicity_post_type  = eventicity_get_theme_option( 'post_type' );
		$eventicity_args       = array(
								'blog_style'     => eventicity_get_theme_option( 'blog_style' ),
								'post_type'      => $eventicity_post_type,
								'taxonomy'       => eventicity_get_post_type_taxonomy( $eventicity_post_type ),
								'parent_cat'     => eventicity_get_theme_option( 'parent_cat' ),
								'posts_per_page' => eventicity_get_theme_option( 'posts_per_page' ),
								'sticky'         => eventicity_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $eventicity_stickies )
															&& count( $eventicity_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		eventicity_blog_archive_start();

		do_action( 'eventicity_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'eventicity_action_before_page_author' );
			get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'eventicity_action_after_page_author' );
		}

		if ( eventicity_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'eventicity_action_before_page_filters' );
			eventicity_show_filters( $eventicity_args );
			do_action( 'eventicity_action_after_page_filters' );
		} else {
			do_action( 'eventicity_action_before_page_posts' );
			eventicity_show_posts( array_merge( $eventicity_args, array( 'cat' => $eventicity_args['parent_cat'] ) ) );
			do_action( 'eventicity_action_after_page_posts' );
		}

		do_action( 'eventicity_action_blog_archive_end' );

		eventicity_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'eventicity_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
