<?php
$eventicity_woocommerce_sc = eventicity_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $eventicity_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$eventicity_scheme = eventicity_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $eventicity_scheme ) && ! eventicity_is_inherit( $eventicity_scheme ) ) {
			echo ' scheme_' . esc_attr( $eventicity_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( eventicity_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( eventicity_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$eventicity_css      = '';
			$eventicity_bg_image = eventicity_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $eventicity_bg_image ) ) {
				$eventicity_css .= 'background-image: url(' . esc_url( eventicity_get_attachment_url( $eventicity_bg_image ) ) . ');';
			}
			if ( ! empty( $eventicity_css ) ) {
				echo ' style="' . esc_attr( $eventicity_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$eventicity_anchor_icon = eventicity_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$eventicity_anchor_text = eventicity_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $eventicity_anchor_icon ) || ! empty( $eventicity_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $eventicity_anchor_icon ) ? ' icon="' . esc_attr( $eventicity_anchor_icon ) . '"' : '' )
											. ( ! empty( $eventicity_anchor_text ) ? ' title="' . esc_attr( $eventicity_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( eventicity_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' eventicity-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$eventicity_css      = '';
				$eventicity_bg_mask  = eventicity_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$eventicity_bg_color_type = eventicity_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $eventicity_bg_color_type ) {
					$eventicity_bg_color = eventicity_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $eventicity_bg_color_type ) {
					$eventicity_bg_color = eventicity_get_scheme_color( 'bg_color', $eventicity_scheme );
				} else {
					$eventicity_bg_color = '';
				}
				if ( ! empty( $eventicity_bg_color ) && $eventicity_bg_mask > 0 ) {
					$eventicity_css .= 'background-color: ' . esc_attr(
						1 == $eventicity_bg_mask ? $eventicity_bg_color : eventicity_hex2rgba( $eventicity_bg_color, $eventicity_bg_mask )
					) . ';';
				}
				if ( ! empty( $eventicity_css ) ) {
					echo ' style="' . esc_attr( $eventicity_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$eventicity_caption     = eventicity_get_theme_option( 'front_page_woocommerce_caption' );
				$eventicity_description = eventicity_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $eventicity_caption ) || ! empty( $eventicity_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $eventicity_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $eventicity_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $eventicity_caption, 'eventicity_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $eventicity_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $eventicity_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $eventicity_description ), 'eventicity_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $eventicity_woocommerce_sc ) {
						$eventicity_woocommerce_sc_ids      = eventicity_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$eventicity_woocommerce_sc_per_page = count( explode( ',', $eventicity_woocommerce_sc_ids ) );
					} else {
						$eventicity_woocommerce_sc_per_page = max( 1, (int) eventicity_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$eventicity_woocommerce_sc_columns = max( 1, min( $eventicity_woocommerce_sc_per_page, (int) eventicity_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$eventicity_woocommerce_sc}"
										. ( 'products' == $eventicity_woocommerce_sc
												? ' ids="' . esc_attr( $eventicity_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $eventicity_woocommerce_sc
												? ' category="' . esc_attr( eventicity_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $eventicity_woocommerce_sc
												? ' orderby="' . esc_attr( eventicity_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( eventicity_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $eventicity_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $eventicity_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
