<div class="front_page_section front_page_section_about<?php
	$eventicity_scheme = eventicity_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $eventicity_scheme ) && ! eventicity_is_inherit( $eventicity_scheme ) ) {
		echo ' scheme_' . esc_attr( $eventicity_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( eventicity_get_theme_option( 'front_page_about_paddings' ) );
	if ( eventicity_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$eventicity_css      = '';
		$eventicity_bg_image = eventicity_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $eventicity_bg_image ) ) {
			$eventicity_css .= 'background-image: url(' . esc_url( eventicity_get_attachment_url( $eventicity_bg_image ) ) . ');';
		}
		if ( ! empty( $eventicity_css ) ) {
			echo ' style="' . esc_attr( $eventicity_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$eventicity_anchor_icon = eventicity_get_theme_option( 'front_page_about_anchor_icon' );
	$eventicity_anchor_text = eventicity_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $eventicity_anchor_icon ) || ! empty( $eventicity_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $eventicity_anchor_icon ) ? ' icon="' . esc_attr( $eventicity_anchor_icon ) . '"' : '' )
									. ( ! empty( $eventicity_anchor_text ) ? ' title="' . esc_attr( $eventicity_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( eventicity_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' eventicity-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$eventicity_css           = '';
			$eventicity_bg_mask       = eventicity_get_theme_option( 'front_page_about_bg_mask' );
			$eventicity_bg_color_type = eventicity_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $eventicity_bg_color_type ) {
				$eventicity_bg_color = eventicity_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $eventicity_bg_color_type ) {
				$eventicity_bg_color = eventicity_get_scheme_color( 'bg_color', $eventicity_scheme );
			} else {
				$eventicity_bg_color = '';
			}
			if ( ! empty( $eventicity_bg_color ) && $eventicity_bg_mask > 0 ) {
				$eventicity_css .= 'background-color: ' . esc_attr(
					1 == $eventicity_bg_mask ? $eventicity_bg_color : eventicity_hex2rgba( $eventicity_bg_color, $eventicity_bg_mask )
				) . ';';
			}
			if ( ! empty( $eventicity_css ) ) {
				echo ' style="' . esc_attr( $eventicity_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$eventicity_caption = eventicity_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $eventicity_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $eventicity_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $eventicity_caption, 'eventicity_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$eventicity_description = eventicity_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $eventicity_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $eventicity_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $eventicity_description ), 'eventicity_kses_content' ); ?></div>
				<?php
			}

			// Content
			$eventicity_content = eventicity_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $eventicity_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $eventicity_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$eventicity_page_content_mask = '%%CONTENT%%';
					if ( strpos( $eventicity_content, $eventicity_page_content_mask ) !== false ) {
						$eventicity_content = preg_replace(
							'/(\<p\>\s*)?' . $eventicity_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$eventicity_content
						);
					}
					eventicity_show_layout( $eventicity_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
