<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package EVENTICITY
 * @since EVENTICITY 1.0
 */

							do_action( 'eventicity_action_page_content_end_text' );
							
							// Widgets area below the content
							eventicity_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'eventicity_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'eventicity_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'eventicity_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'eventicity_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$eventicity_body_style = eventicity_get_theme_option( 'body_style' );
					$eventicity_widgets_name = eventicity_get_theme_option( 'widgets_below_page', 'hide' );
					$eventicity_show_widgets = ! eventicity_is_off( $eventicity_widgets_name ) && is_active_sidebar( $eventicity_widgets_name );
					$eventicity_show_related = eventicity_is_single() && eventicity_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $eventicity_show_widgets || $eventicity_show_related ) {
						if ( 'fullscreen' != $eventicity_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $eventicity_show_related ) {
							do_action( 'eventicity_action_related_posts' );
						}

						// Widgets area below page content
						if ( $eventicity_show_widgets ) {
							eventicity_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $eventicity_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'eventicity_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'eventicity_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! eventicity_is_singular( 'post' ) && ! eventicity_is_singular( 'attachment' ) ) || ! in_array ( eventicity_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="eventicity_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'eventicity_action_before_footer' );

				// Footer
				$eventicity_footer_type = eventicity_get_theme_option( 'footer_type' );
				if ( 'custom' == $eventicity_footer_type && ! eventicity_is_layouts_available() ) {
					$eventicity_footer_type = 'default';
				}
				get_template_part( apply_filters( 'eventicity_filter_get_template_part', "templates/footer-" . sanitize_file_name( $eventicity_footer_type ) ) );

				do_action( 'eventicity_action_after_footer' );

			}
			?>

			<?php do_action( 'eventicity_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'eventicity_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'eventicity_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>